﻿<%@ Page Language="c#" CodePage="1200" AutoEventWireup="false" %>

<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Business" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Dekret</title>
	<script runat="server">
    
    void Dekret_OnLoad(Object sender, EventArgs args)
	{
        DekretBase dekret  = (DekretBase)DataContext1.Get(typeof(DekretBase));

		ReportHeader1.Title = String.Format(ReportHeader1.Title,
			dekret.Typ == TypDziennika.BO ? "Polecenie księgowania BO" : "Polecenie księgowania",
			dekret.Numer,
			dekret.Data,
			dekret.Bufor ? "Tak" : "Nie",
			dekret.Ewidencja.NumerDokumentu,
			dekret.Ewidencja.DataDokumentu,
			dekret.Opis,
			dekret.Winien,
			dekret.Ma,
			dekret.Ewidencja.Numer.NumerPelny,
			dekret.Ewidencja.Opis);
    }
	</script>
</head>
<body>
	<form id="PK" method="post" runat="server" onload="Dekret_OnLoad">
	<p>
		<ea:datacontext id="DataContext1" runat="server" typename="Soneta.Ksiega.DekretBase, Soneta.Ksiega" />
		<cc1:reportheader id="ReportHeader1" title="{0}|</STRONG>Nr dokumentu:<STRONG> {4}|</STRONG>Data dokumentu:<STRONG> {5}|</STRONG>Nr ewidencji:<STRONG> {9}|</STRONG>Opis ew.:<STRONG> {10}" runat="server" />

		<ea:grid id="Grid1" runat="server" RowTypeName="Soneta.Ksiega.ZapisKsiegowy,Soneta.Ksiega" DataMember="Zapisy" ShowPageSum="true" >
			<Columns>
				<ea:GridColumn runat="server" Width="7" Align="Center" DataMember="Lp" Caption="Lp." />
				<ea:GridColumn runat="server" Width="7" Align="Center" DataMember="Grupa" Caption="Gr." />
				<ea:GridColumn runat="server" Width="30" DataMember="Konto.Symbol" Total="Info" Caption="Symbol konta" />
				<ea:GridColumn runat="server" Width="20" Align="Right" DataMember="Winien.Value" Total="Sum" Caption="Winien" Format="{0:n}" />
				<ea:GridColumn runat="server" Width="20" Align="Right" DataMember="Ma.Value" Total="Sum" Caption="Ma" Format="{0:n}" />
				<ea:GridColumn runat="server" DataMember="Opis" />
			</Columns>
		</ea:grid>

		<cc1:reportfooter id="ReportFooter1" runat="server">
			<Subtitles>
				<cc1:FooterSubtitle runat="server" SubtitleType="Operator" />
				<cc1:FooterSubtitle runat="server" Caption="Sporządził/Zaksięgował:" SubtitleType="Podpis" Width="30" />
			</Subtitles>
		</cc1:reportfooter>
	</form>
</body>
</html>

